/**
 * يتحقق أن الـ Blueprints منطقية (sanity checks)
 * - baseCorrelation ضمن نطاق منطقي
 * - volatility محدود
 * - support كافي
 */
import { MetaConfig } from '../../config/meta.config';

export function validateRewrites(
  blueprints: Array<{
    policyId: string;
    baseCorrelation: number;
    volatility: number;
    support: number;
    mutation: 'expand' | 'contract';
    version: number;
    rationale: string;
  }>
) {
  return blueprints.map((bp) => {
    const okCorr = Math.abs(bp.baseCorrelation) <= 1.25; // guard بسيط
    const okVol = bp.volatility <= MetaConfig.volatilityMax;
    const okSup = bp.support >= MetaConfig.minSupport;

    const valid = okCorr && okVol && okSup;

    return {
      policyId: bp.policyId,
      version: bp.version,
      valid,
      reason: valid
        ? 'Blueprint منطقي ومستقر ويمكن تجربته.'
        : `مرفوض: corr=${bp.baseCorrelation}, vol=${bp.volatility}, support=${bp.support}`,
      action: valid
        ? bp.mutation === 'expand'
          ? 'increase_weight_gradually'
          : 'decrease_weight_or_monitor'
        : 'none',
    };
  });
}
