/**
 * Phase 6.2 compatibility adapter
 * This provides createSnapshot() for legacy tests.
 */
import { toSnapshot } from './snapshot';
import type { FeedbackReport } from '../../types/phase5';

export function createSnapshot(iteration: number, payload: any) {
  const report: FeedbackReport = {
    iteration,
    timestamp: payload.timestamp || new Date().toISOString(),
    policies: payload.policies || [],
    notes: payload.notes || '',
  };
  return toSnapshot(report);
}

// 🔥 ensure export exists at runtime
export default { createSnapshot };
