// lib/evolution/calibration.config.ts
export type CalibrationMode = 'zscore' | 'minmax';
export interface CalibrationConfig {
  windowSize: number; // حجم نافذة التاريخ للمعايرة
  mode: CalibrationMode; // طريقة التطبيع
  epsilon: number; // حماية من القسمة على صفر
  clamp?: [number, number]; // حدود نهائية للقيم (اختياري)
}

export const DEFAULT_CALIBRATION: CalibrationConfig = {
  windowSize: 14, // 14 نقطة/يوم
  mode: 'zscore',
  epsilon: 1e-6,
  clamp: [0, 1], // نقيد المؤشرات [0..1]
};
