// lib/awareness/events.ts

// Top-level debug flag
export const DEBUG = process.env.NODE_ENV !== 'production';

// Environment-driven guards
export const AWARENESS_ENABLED = DEBUG || process.env.AWARENESS_ENABLED === 'true' || process.env.TEST_AWARENESS === 'true';
export const TELEMETRY_ENABLED = DEBUG || process.env.TELEMETRY_ENABLED === 'true' || process.env.TEST_TELEMETRY === 'true';

export enum AwarenessEvent {
  DESKTOP_LOADED = 'DESKTOP_LOADED',
  WINDOW_OPENED = 'WINDOW_OPENED',
  WINDOW_CLOSED = 'WINDOW_CLOSED',
  WINDOW_FOCUSED = 'WINDOW_FOCUSED',
  TELEMETRY_METRIC = 'TELEMETRY_METRIC',
}

export type DesktopLoadedPayload = {
  timestamp: number;
  openWindows: number;
  activeWindow: string | null;
};

export type WindowOpenedPayload = {
  windowId: string;
  timestamp: number;
};

export type WindowClosedPayload = {
  windowId: string;
  timestamp: number;
};

export type WindowFocusedPayload = {
  windowId: string;
  timestamp: number;
};

export type TelemetryMetricPayload = {
  name: string;
  value: number;
  tags?: Record<string, string>;
};

export type AwarenessEventPayload =
  | { type: AwarenessEvent.DESKTOP_LOADED; payload: DesktopLoadedPayload }
  | { type: AwarenessEvent.WINDOW_OPENED; payload: WindowOpenedPayload }
  | { type: AwarenessEvent.WINDOW_CLOSED; payload: WindowClosedPayload }
  | { type: AwarenessEvent.WINDOW_FOCUSED; payload: WindowFocusedPayload }
  | { type: AwarenessEvent.TELEMETRY_METRIC; payload: TelemetryMetricPayload };
