/**
 * @file MetaForecastCard.tsx
 * كارت صغير يعرض الاتجاه العام وتحليل الـ Meta Forecast
 */

import React from "react";
import { generateMetaForecast } from "@/lib/evolution/meta-forecast";

export const MetaForecastCard: React.FC = () => {
  const forecast = generateMetaForecast();

  const trendColors = {
    Integrate: "#00ff88",
    Reform: "#f4d03f",
    Reset: "#ff4d4f",
  } as const;

  return (
    <div className="meta-forecast-card bg-[#111] p-5 rounded-2xl shadow-lg border border-[#222]">
      <h3 className="text-[#f47b46] mb-3 font-semibold text-lg">
        Meta-Forecast
      </h3>
      <div className="flex justify-between items-center mb-2">
        <span className="text-gray-400">Trend:</span>
        <span
          className="font-bold"
          style={{ color: trendColors[forecast.trend] }}
        >
          {forecast.trend}
        </span>
      </div>
      <div className="flex justify-between items-center mb-2">
        <span className="text-gray-400">Confidence:</span>
        <span className="text-white">
          {(forecast.confidence * 100).toFixed(1)}%
        </span>
      </div>
      <div className="flex justify-between items-center mb-2">
        <span className="text-gray-400">Change Rate:</span>
        <span className="text-white">
          {forecast.changeRate.toFixed(2)}%
        </span>
      </div>
      <p className="text-sm text-gray-300 mt-3 italic">
        {forecast.recommendation}
      </p>
      <p className="text-xs text-gray-500 mt-2">
        Last updated: {new Date(forecast.timestamp).toLocaleString()}
      </p>
    </div>
  );
};
