"use client"
import React from "react" // Import React
import styles from "./FolderContent.module.css"
import { Mail, Phone, Globe, Linkedin, Github } from "lucide-react"

const ContactFolder: React.FC = () => { // Add React.FC type
  return (
    <div className={styles.folderContainer}>
      <h1 className={styles.folderTitle}>Contact Information</h1>

      <div className={styles.contactCard}>
        <div className={styles.contactItem}>
          <Mail size={24} className={styles.contactIcon} />
          <div className={styles.contactDetails}>
            <span className={styles.contactLabel}>Email</span>
            <a href="mailto:mohamed49.fcis@gmail.com" className={styles.contactValue}>
              mohamed49.fcis@gmail.com
            </a>
          </div>
        </div>

        <div className={styles.contactItem}>
          <Phone size={24} className={styles.contactIcon} />
          <div className={styles.contactDetails}>
            <span className={styles.contactLabel}>Phone</span>
            <a href="tel:+201157828998" className={styles.contactValue}>
              (+20) 1157-828-998
            </a>
          </div>
        </div>

        <div className={styles.contactItem}>
          <Linkedin size={24} className={styles.contactIcon} />
          <div className={styles.contactDetails}>
            <span className={styles.contactLabel}>LinkedIn</span>
            <a
              href="https://linkedin.com/in/mohamed-gamal"
              target="_blank"
              rel="noopener noreferrer"
              className={styles.contactValue}
            >
              LinkedIn Profile
            </a>
          </div>
        </div>

        <div className={styles.contactItem}>
          <Github size={24} className={styles.contactIcon} />
          <div className={styles.contactDetails}>
            <span className={styles.contactLabel}>GitHub</span>
            <a
              href="https://github.com/mohamed-gamal"
              target="_blank"
              rel="noopener noreferrer"
              className={styles.contactValue}
            >
              GitHub Profile
            </a>
          </div>
        </div>

        <div className={styles.contactItem}>
          <Globe size={24} className={styles.contactIcon} />
          <div className={styles.contactDetails}>
            <span className={styles.contactLabel}>Portfolio</span>
            <a
              href="https://mohamed-gamal-portfolio.com"
              target="_blank"
              rel="noopener noreferrer"
              className={styles.contactValue}
            >
              Portfolio Website
            </a>
          </div>
        </div>
      </div>
    </div>
  )
}

export default ContactFolder; // Export as default