import { describe, it, expect } from 'vitest';
import fs from 'node:fs';
import { runAdaptiveEvolution } from '../../lib/evolution/adaptive_engine';
import { EvolutionConfig } from '../../config/evolution.config';

describe('Phase 6.3 — Adaptive Evolution Engine', () => {
  it('creates evolved weights and logs experiments', () => {
    const log = runAdaptiveEvolution();
    expect(Array.isArray(log)).toBe(true);
    expect(log.length).toBeGreaterThan(0);
    expect(fs.existsSync(EvolutionConfig.evolutionLog)).toBe(true);
  });
});
