import { describe, it, expect } from 'vitest';
import fs from 'node:fs';
import { PolicyManager } from '../../lib/policies/PolicyManager';
import { appendPolicyHistory, getLastPolicyECI } from '../../lib/integration/policy_history';

describe('🧩 Phase 8.6 — Policy Heatmap & ECI', () => {
  it('records snapshots into policy_history.json', () => {
    const snap = PolicyManager.detect();
    appendPolicyHistory(snap);
    const json = JSON.parse(fs.readFileSync('./storage/policy_history.json', 'utf8'));
    expect(json.length).toBeGreaterThan(0);
    expect(json.at(-1)).toHaveProperty('eci');
  });

  it('calculates Environment Confidence Index correctly', () => {
    const eci = getLastPolicyECI();
    expect(eci).toBeGreaterThan(0);
    expect(eci).toBeLessThanOrEqual(1);
  });
});
