import { describe, it, expect } from 'vitest';
import { evaluate } from '../../lib/feedback/evaluator';
import type { Signal } from '../../lib/feedback/types';

describe('🧪 Evaluator — Phase 6.1 Edge-Ready', () => {
  it('returns NORMAL for low signals', () => {
    const r = evaluate([{ kind: 'LOAD', value: 5 }]);
    expect(r.severity).toBe('NORMAL');
  });

  it('produces WARNING when latency moderate', () => {
    const r = evaluate([
      { kind: 'LATENCY', value: 50 },
      { kind: 'LOAD', value: 45 },
    ]);
    expect(['WARNING', 'CRITICAL']).toContain(r.severity);
  });

  it('produces CRITICAL on high spikes', () => {
    const r = evaluate([
      { kind: 'ERROR', value: 90 },
      { kind: 'LATENCY', value: 85 },
    ]);
    expect(r.severity).toBe('CRITICAL');
  });

  it('handles empty signals gracefully', () => {
    const r = evaluate([]);
    expect(r.confidence).toBeGreaterThanOrEqual(0.3);
    expect(r.severity).toBe('NORMAL');
  });
});
