/**
 * Runner: Phase 6.5 — Meta Reflection & Self-Rewrite
 * 1) detect patterns
 * 2) generate blueprints
 * 3) validate plan
 * 4) (optional) apply plan with dryRun or real apply
 */
import { detectMetaPatterns } from '../meta/reflection_core';
import { generateBlueprints } from '../meta/blueprint_generator';
import { validateRewrites } from '../meta/rewrite_validator';
import { applyBlueprints } from '../meta/apply_blueprints';
import { MetaConfig } from '../../config/meta.config';

(async () => {
  console.log('🧠 Running Meta-Reflection...');
  const patterns = detectMetaPatterns();
  console.table(patterns);

  const blueprints = generateBlueprints(patterns);
  console.log('—— Generated Blueprints ——');
  console.table(blueprints);

  const plan = validateRewrites(blueprints);
  console.log('—— Validation Plan ——');
  console.table(plan);

  // Dry-run first (safety)
  const dryRes = applyBlueprints(plan, { dryRun: true, step: 0.05 });
  console.log('—— Dry-Run Updates ——');
  console.table(dryRes.updates);

  // Uncomment to perform a real apply (after reviewing plan):
  const realRes = applyBlueprints(plan, { dryRun: false, step: 0.05 });
  console.log('—— REAL Updates ——');
  console.table(realRes.updates);

  console.log(`✅ Meta-Reflection complete (dryRun=${MetaConfig.dryRunByDefault}).`);
})();
