// lib/reflection/observe.ts

import { publish as publishToAwarenessBus } from '@/lib/awareness';
import { isReflectionEnabled } from './flags';
import type {
  Signal,
  EvaluationResult,
  FeedbackDecision,
  PolicyState,
  ReflectionEventPayload,
} from './types';
import { ReflectionEvent } from './types';

function publish(payload: ReflectionEventPayload) {
  if (!isReflectionEnabled()) return;
  // This is a bit of a type hack, as the main bus expects AwarenessEventPayload.
  // In a larger system, we might have a more generic event bus.
  publishToAwarenessBus(payload as any);
}

export function publishSignal(signal: Signal): void {
  publish({ type: ReflectionEvent.SIGNAL_COMPUTED, payload: signal });
}

export function publishEvaluation(evaluation: EvaluationResult): void {
  publish({ type: ReflectionEvent.EVALUATION_PERFORMED, payload: evaluation });
}

export function publishDecision(decision: FeedbackDecision): void {
  publish({ type: ReflectionEvent.DECISION_MADE, payload: decision });
}

export function publishPolicyChange(oldState: PolicyState, newState: PolicyState): void {
  publish({ type: ReflectionEvent.POLICY_CHANGED, payload: { old: oldState, new: newState } });
}
