/**
 * @file policy_telemetry.ts
 * Phase 8.5 — Responsive Policy Telemetry Logger
 * -----------------------------------------------
 * يسجّل كل snapshot من PolicyManager داخل Evolution_Report.json
 * لتتبع تغيّر البيئة عبر الزمن (context-aware tracking).
 */

import fs from 'node:fs';
import path from 'node:path';
import { PolicySnapshot } from '../policies/PolicyManager';

const storagePath = path.resolve('./storage/Evolution_Report.json');

/**
 * Append responsive policy snapshot to Evolution_Report.json
 */
export function appendPolicyTelemetry(snapshot: PolicySnapshot) {
  try {
    // إنشاء الملف لو مش موجود
    if (!fs.existsSync(path.dirname(storagePath))) {
      fs.mkdirSync(path.dirname(storagePath), { recursive: true });
    }

    // قراءة التقرير القديم (إن وجد)
    const json = fs.existsSync(storagePath) ? JSON.parse(fs.readFileSync(storagePath, 'utf8')) : {};

    // تحديث البيانات
    json.responsivePolicy = snapshot;
    json.lastPolicyUpdate = new Date().toISOString();

    // حفظ الملف النهائي
    fs.writeFileSync(storagePath, JSON.stringify(json, null, 2));

    console.log('🧩 [Telemetry] Responsive policy logged.');
  } catch (err) {
    console.error('Telemetry error:', err);
  }
}
