import type { Policy, Evaluation } from './types';

// سياسة افتراضية
export const DefaultPolicy: Policy = {
  version: '1.0.0',
  cooldownMs: 1500,
  params: {
    rateStep: 0.1,
    raiseStep: 5,
  },
};

// اختيار الإجراء بناءً على التقييم
export function chooseAction(evaln: Evaluation, policy: Policy) {
  // CRITICAL بسبب ERROR → ROLLBACK
  if (evaln.severity === 'CRITICAL') {
    if (evaln.reasons?.some((r) => r.includes('ERROR'))) {
      return { id: crypto.randomUUID(), kind: 'ROLLBACK' as const };
    }
    // CRITICAL بسبب LATENCY → ENABLE_CACHE
    if (evaln.reasons?.some((r) => r.includes('LATENCY'))) {
      return { id: crypto.randomUUID(), kind: 'ENABLE_CACHE' as const };
    }
    // افتراضيًا في الكريتيكال نعمل ROLLBACK
    return { id: crypto.randomUUID(), kind: 'ROLLBACK' as const };
  }

  // WARNING → تقليل الريت بنصف الـ step
  if (evaln.severity === 'WARNING') {
    return {
      id: crypto.randomUUID(),
      kind: 'ADJUST_RATE' as const,
      args: { delta: -DefaultPolicy.params.rateStep / 2 },
    };
  }

  // NORMAL + ثقة عالية → RAISE_LIMIT
  if (evaln.severity === 'NORMAL' && (evaln.confidence ?? 0) >= 0.8) {
    return {
      id: crypto.randomUUID(),
      kind: 'RAISE_LIMIT' as const,
      args: { delta: DefaultPolicy.params.raiseStep },
    };
  }

  // لا إجراء
  return null;
}
