import type { FeedbackEvent } from './types';

type TimelineEvent = FeedbackEvent & {
  result?: any;
  blockedBy?: string | null;
};

const timeline: TimelineEvent[] = [];

// alias مطابق لكل الأسماء المستخدمة في التيستات
export async function recordFeedback(e: TimelineEvent) {
  timeline.push(e);
}

export async function record(e: TimelineEvent) {
  return recordFeedback(e);
}

export function getTimeline() {
  return timeline;
}

export function clearTimeline() {
  timeline.length = 0;
}

// إرجاع آخر أكشنات من نوع معيّن
export function lastActions(kind: string) {
  return timeline
    .map((t) => t.chosenAction)
    .filter(Boolean)
    .filter((a) => a!.kind === kind);
}

// alias لاسم بديل ظهر في بعض التيستات
export const getLastActions = lastActions;
