// lib/feedback/actions.ts
import { Action, ActionResult } from './types';

export async function execute(action: Action): Promise<ActionResult> {
  const started = performance.now();
  try {
    switch (action.kind) {
      case 'ENABLE_CACHE':
        // Simulated operation
        await sleep(50);
        break;
      case 'ADJUST_RATE':
        await sleep(30);
        break;
      case 'ROLLBACK':
        await sleep(70);
        break;
      case 'DISABLE_FEATURE':
      case 'RAISE_LIMIT':
        await sleep(40);
        break;
    }

    return {
      actionId: action.id,
      ok: true,
      latencyMs: performance.now() - started,
    };
  } catch (e: any) {
    return {
      actionId: action.id,
      ok: false,
      latencyMs: performance.now() - started,
      error: String(e),
    };
  }
}

function sleep(ms: number) {
  return new Promise((res) => setTimeout(res, ms));
}
