import type { DeviceKind } from './types';

export function detectDeviceKind(width = window.innerWidth): DeviceKind {
  if (width <= 768) return 'mobile';
  if (width <= 1200) return 'tablet';
  return 'desktop';
}

export function prefersReducedMotion(): boolean {
  return window.matchMedia?.('(prefers-reduced-motion: reduce)').matches ?? false;
}

export function isLowEndHardware(): boolean {
  const cores = (navigator as any).hardwareConcurrency ?? 4;
  return cores <= 4;
}
