// src/lib/awareness/collective/components/charts/types.ts
export type Trend = 'Integrate' | 'Reform' | 'Reset';

/**
 * الشكل الموحّد لكل نقطة هتترسم في الـ Evolution History Chart
 */
export interface ChartDataPoint {
  /** التاريخ (بالـ milliseconds عشان Recharts يقرأه كـ وقت) */
  timestamp: number;
  /** القيمة الرقمية للـ trend  (1 = Integrate | 2 = Reform | 3 = Reset) */
  trendValue: 1 | 2 | 3;
  /** الاسم الأصلي للاتجاه (عشان اللون والـ Tooltip) */
  originalTrend: Trend;
  /** مستوى الثقة 0 → 1 */
  confidence: number;
  /** نسبة معدل التغيير % */
  changeRate: number;
  /** ملاحظات إضافية لو موجودة */
  notes?: string;
}
