"use client";
import PredictiveDashboardContent from '@/components/windows/PredictiveDashboardContent';
import {
  Github,
  Linkedin,
  Instagram,
  Chrome,
  Mail,
  FileText,
  Code,
  User,
  Briefcase,
  GraduationCap,
  Award,
} from "lucide-react";

import AboutContent from "@/components/windows/AboutContent";
import ProjectsContent from "@/components/windows/ProjectsContent";
import SkillsContent from "@/components/windows/SkillsContent";
import ContactContent from "@/components/windows/ContactContent";
import ResumeContent from "@/components/windows/ResumeContent";
import BrowserContent from "@/components/windows/BrowserContent";

import type { AppMeta } from "@/types/portfolio"; // ✅ أنواع موحدة

// =============================
// 🖥️ Desktop Applications
// =============================
export const desktopApps: AppMeta[] = [
  {
  id: 'predictive-dashboard',
  name: 'Predictive Layer',
  icon: '🔮',         // يمكن لاحقاً تبديلها لأيقونة SVG من /public لو حابب
  type: 'internal',
  component: PredictiveDashboardContent,
},
  {
    id: "about",
    name: "About Me",
    icon: "👤",
    type: "internal",
    component: AboutContent,
  },
  {
    id: "projects",
    name: "Projects",
    icon: "💻",
    type: "internal",
    component: ProjectsContent,
  },
  {
    id: "skills",
    name: "Tech Stack",
    icon: "🧠",
    type: "internal",
    component: SkillsContent,
  },
  {
    id: "contact",
    name: "Contact",
    icon: "📧",
    type: "internal",
    component: ContactContent,
  },
  {
    id: "resume",
    name: "Resume",
    icon: "📄",
    type: "internal",
    component: ResumeContent,
  },
  {
    id: "github",
    name: "GitHub",
    icon: "🐙",
    type: "browser",
    component: BrowserContent,
    url: "https://github.com/mohamed-gamal",
  },
  {
    id: "linkedin",
    name: "LinkedIn",
    icon: "💼",
    type: "browser",
    component: BrowserContent,
    url: "https://linkedin.com/in/mohamed-gamal",
  },
  {
    id: "instagram",
    name: "Instagram",
    icon: "📸",
    type: "browser",
    component: BrowserContent,
    url: "https://instagram.com/your-username",
  },
  {
    id: "web-browser",
    name: "Web Browser",
    icon: "🌐",
    type: "browser",
    component: BrowserContent,
    url: "https://www.google.com",
  },
  {
    id: "education",
    name: "Education",
    icon: "🎓",
    type: "internal",
    component: AboutContent, // Placeholder
  },
  {
    id: "certifications",
    name: "Certifications",
    icon: "🏅",
    type: "internal",
    component: AboutContent, // Placeholder
  },
];

// ✅ Export alias (used by deep-linking logic)
export const allApps: AppMeta[] = desktopApps;

// =============================
// 👤 Personal Info
// =============================
export const personalInfo = {
  name: "Mohamed Gamal",
  title: "Team Lead & Senior Backend Engineer (Laravel + React.js)",
  location: "New Cairo, Egypt",
  email: "mohamed49.fcis@gmail.com",
  phone: "(+20) 1157-828-998",
  linkedin: "https://linkedin.com/in/mohamed-gamal",
  github: "https://github.com/mohamed-gamal",
  portfolio: "https://mohamed-gamal.dev",
  summary:
    "Certified Psychological Consultant—licensed across the Arab World—bringing unique coaching insight to tech leadership. Senior Backend Engineer & Team Lead with 7+ years of experience building scalable systems using Laravel, REST APIs, and modular architectures. Led engineering teams across logistics, real estate, e-commerce, and CRM domains. Combines deep technical execution with emotional intelligence to drive delivery and build psychologically safe, high-performing teams.",
};

// =============================
// 🚀 Projects
// =============================
export const projects = [
  {
    id: "farm-trade-field",
    name: "Farm Trade Field Operations System",
    role: "Senior Backend Engineer",
    techStack: [
      "Laravel",
      "Google Maps API",
      "Leaflet.js",
      "GPS Integration",
      "Real-time Tracking",
    ],
    description:
      "GPS-based dispatch system matching nearest field agents to farm locations in real time. Integrated Google Maps API and Leaflet.js for live route tracking. Custom shortest-path logic reduced fuel usage by 25% and optimized travel. Delivered live trip history, congestion avoidance, and automated reporting.",
    impact: "Reduced fuel usage by 25% and optimized travel routes",
    image: "/placeholder.svg?height=300&width=500",
    link: null,
  },
  {
    id: "yousry-erp",
    name: "Yousry ERP System",
    role: "Team Lead",
    techStack: [
      "Laravel",
      "React.js",
      "Modular Architecture",
      "Queue System",
      "FullCalendar.js",
    ],
    description:
      "Led React.js adoption and mentored engineering team on best practices and clean code. Designed and deployed modular ERP for Yousry Group (orders, HR, chat, tracking). Built custom notification engine and calendar workflows using Laravel Queues + FullCalendar.js. Delivered role-based multilingual UI aligned with complex business logic.",
    impact:
      "Reduced manual operations by 40% and cut bug reports by 60% within first quarter",
    image: "/placeholder.svg?height=300&width=500",
    link: null,
  },
  {
    id: "botit",
    name: "Botit Food Delivery Platform",
    role: "Project Owner & Senior Developer",
    techStack: ["Laravel", "MongoDB", "Mobile API Sync", "Real-time Systems"],
    description:
      "Project owner of Botit platform used by major brands like KFC, McDonald's, and Mo'men. Designed and maintained APIs, cashier systems, notifications, and mobile sync using Laravel + MongoDB. Led backend team of 8 developers and coordinated with mobile team of 6.",
    impact:
      "Handled 10,000+ monthly orders and improved backend response time by 35%",
    image: "/placeholder.svg?height=300&width=500",
    link: "https://www.botitapp.com/",
  },
  {
    id: "rindex",
    name: "Rindex Real Estate Platform",
    role: "Senior Web Developer",
    techStack: ["Laravel", "Real Estate APIs", "Trello API", "SMS Integration"],
    description:
      "Built Rindex, a real estate sync platform integrating listings across multiple systems. Developed comprehensive CRM with dashboards, Trello API integration, and automated SMS workflows for real estate brokers and agents.",
    impact: "Delivered all releases remotely with zero major post-launch issues",
    image: "/placeholder.svg?height=300&width=500",
    link: null,
  },
  {
    id: "easy-cook",
    name: "Easy Cook Nutrition Platform",
    role: "Lead Backend Engineer",
    techStack: [
      "Laravel",
      "FullCalendar.js",
      "Paymob Integration",
      "Role-based Dashboards",
    ],
    description:
      "Architected and implemented a subscription-based nutrition platform with role-specific dashboards (Admin, Nutritionist, User). Developed logic to track and display meals, macros, and progress using FullCalendar. Integrated Paymob payment gateway and real-time feedback systems.",
    impact: "Processed over 1,000 nutrition assessments per month",
    image: "/placeholder.svg?height=300&width=500",
    link: null,
  },
];

// =============================
// ⚙️ Tech Stack
// =============================
export const techStack = {
  backend: [
    { name: "Laravel", level: "Expert", years: "7+ (v4.3-12)", icon: "🔧" },
    { name: "PHP", level: "Expert", years: "7+", icon: "🐘" },
    { name: "MySQL", level: "Expert", years: "7+", icon: "🗄️" },
    { name: "MongoDB", level: "Advanced", years: "4+", icon: "🍃" },
    { name: "RESTful APIs", level: "Expert", years: "7+", icon: "🔗" },
    { name: "SOLID Principles", level: "Expert", years: "6+", icon: "🏗️" },
  ],
  frontend: [
    { name: "React.js", level: "Advanced", years: "3+", icon: "⚛️" },
    { name: "Vue.js", level: "Advanced", years: "4+", icon: "💚" },
    { name: "JavaScript", level: "Expert", years: "7+", icon: "📜" },
    { name: "TailwindCSS", level: "Advanced", years: "3+", icon: "🎨" },
    { name: "Blade Templates", level: "Expert", years: "7+", icon: "⚔️" },
    { name: "Bootstrap", level: "Advanced", years: "6+", icon: "🅱️" },
  ],
  devops: [
    { name: "Git", level: "Expert", years: "7+", icon: "📝" },
    { name: "Bitbucket", level: "Advanced", years: "5+", icon: "🪣" },
    { name: "Git Hooks", level: "Advanced", years: "3+", icon: "🪝" },
    { name: "WHM/cPanel", level: "Advanced", years: "4+", icon: "🖥️" },
    { name: "Deployment", level: "Expert", years: "6+", icon: "🚀" },
  ],
  integrations: [
    { name: "Paymob", level: "Expert", years: "3+", icon: "💳" },
    { name: "MyFatoorah", level: "Advanced", years: "2+", icon: "💰" },
    { name: "Google Maps API", level: "Advanced", years: "2+", icon: "🗺️" },
    { name: "Trello API", level: "Advanced", years: "2+", icon: "📋" },
    { name: "SMS APIs", level: "Advanced", years: "2+", icon: "📱" },
  ],
  leadership: [
    { name: "Team Leadership", level: "Expert", years: "4+", icon: "👑" },
    { name: "Scrum/Agile", level: "Advanced", years: "5+", icon: "🔄" },
    { name: "Code Reviews", level: "Expert", years: "5+", icon: "👥" },
    { name: "Mentoring", level: "Expert", years: "4+", icon: "🎓" },
    { name: "Documentation", level: "Expert", years: "6+", icon: "📚" },
  ],
  specializations: [
    { name: "System Architecture", level: "Advanced", years: "4+", icon: "🏛️" },
    { name: "AI Concepts", level: "Intermediate", years: "2+", icon: "🤖" },
    { name: "NLP (Academic)", level: "Intermediate", years: "1+", icon: "🧠" },
    { name: "Psychological Consulting", level: "Certified", years: "Licensed", icon: "🧘" },
  ],
};

// =============================
// 💭 Philosophy
// =============================
export const philosophy = [
  "I believe great software is built with intention, clarity, and collaboration.",
  "I follow SOLID principles, and I document as I build.",
  "My focus is always on making scalable systems that feel human – whether it's a CRM, an education tool, or an internal dashboard.",
  "Advocate for logic-driven development over improvisation.",
  "Committed to clean code, documentation, and SOLID architecture.",
  "Believer in tech solutions aligned with real business needs.",
  "Lead by example and promote team ownership and collaboration.",
];
