"use client";

import { projects } from "@/data/apps";
import styles from "@/components/windows/WindowContent.module.css";
import { ExternalLink } from "lucide-react";

// 🧠 Debug toggle
const DEBUG =
  (typeof process !== "undefined" &&
    process.env.NODE_ENV !== "production") ||
  (typeof process !== "undefined" &&
    process.env.NEXT_PUBLIC_DEBUG === "true");

const dlog = (...args: any[]) => {
  if (DEBUG) console.log("[ProjectsContent]", ...args);
};

export default function ProjectsContent() {
  if (!Array.isArray(projects) || projects.length === 0) {
    dlog("⚠️ No projects found – showing fallback.");
    return (
      <div className={styles.windowContent}>
        <section className={styles.contentSection}>
          <h2>My Projects</h2>
          <p>No projects data available at the moment.</p>
        </section>
      </div>
    );
  }

  dlog(`🧱 Rendering ${projects.length} projects`);

  return (
    <div className={styles.windowContent}>
      <section className={styles.contentSection}>
        <h2>My Projects</h2>
        <div className={styles.projectsGrid}>
          {projects.map((project) => {
            const {
              id,
              image,
              name,
              role,
              description,
              impact,
              techStack = [],
              link,
            } = project || {};

            return (
              <div key={id || Math.random()} className={styles.projectCard}>
                <img
                  src={image || "/placeholder.svg"}
                  alt={name || "Project"}
                  className={styles.projectImage}
                  loading="lazy"
                />
                <div className={styles.projectContent}>
                  <h3>{name || "Untitled Project"}</h3>
                  {role && (
                    <p>
                      <strong>Role:</strong> {role}
                    </p>
                  )}
                  {description && <p>{description}</p>}
                  {impact && (
                    <p>
                      <strong>Impact:</strong> {impact}
                    </p>
                  )}
                  {Array.isArray(techStack) && techStack.length > 0 && (
                    <div className={styles.techStack}>
                      {techStack.map((tech, index) => (
                        <span key={index} className={styles.techTag}>
                          {tech}
                        </span>
                      ))}
                    </div>
                  )}
                  {link && (
                    <a
                      href={link}
                      target="_blank"
                      rel="noopener noreferrer"
                      className={styles.projectLink}
                    >
                      View Project <ExternalLink size={16} />
                    </a>
                  )}
                </div>
              </div>
            );
          })}
        </div>
      </section>
    </div>
  );
}
