'use client';
/**
 * Predictive Dashboard window host
 * Loads the CollectiveAdaptiveDashboard lazily inside OS Window content.
 */
import React, { lazy, Suspense } from 'react';
import { motion } from 'framer-motion';

const CollectiveAdaptiveDashboard = lazy(() =>
  import('@/lib/awareness/collective/CollectiveAdaptiveDashboard').then(m => ({
    default: m.CollectiveAdaptiveDashboard,
  }))
);

function LoadingFallback() {
  return (
    <div
      style={{
        display: 'flex', justifyContent: 'center', alignItems: 'center',
        height: '100%', color: '#0c7a7a', fontSize: 14,
      }}
    >
      Initializing Predictive Layer...
    </div>
  );
}

export default function PredictiveDashboardContent() {
  return (
    <motion.div
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      transition={{ duration: 0.5 }}
      style={{ width: '100%', height: '100%', background: '#010508' }}
    >
      <Suspense fallback={<LoadingFallback />}>
        <CollectiveAdaptiveDashboard />
      </Suspense>
    </motion.div>
  );
}
