"use client"
import React from "react" // Import React
import styles from "./FolderContent.module.css"

const PersonalInfoFolder: React.FC = () => { // Add React.FC type
  return (
    <div className={styles.folderContainer}>
      <h1 className={styles.folderTitle}>Personal Information</h1>

      <div className={styles.infoCard}>
        <div className={styles.infoRow}>
          <span className={styles.infoLabel}>Name:</span>
          <span className={styles.infoValue}>Mohamed Gamal</span>
        </div>
        <div className={styles.infoRow}>
          <span className={styles.infoLabel}>Title:</span>
          <span className={styles.infoValue}>Team Lead | Full Stack Engineer (Laravel + Vue.js)</span>
        </div>
        <div className={styles.infoRow}>
          <span className={styles.infoLabel}>Location:</span>
          <span className={styles.infoValue}>New Cairo, Egypt</span>
        </div>
        <div className={styles.infoRow}>
          <span className={styles.infoLabel}>Experience:</span>
          <span className={styles.infoValue}>7+ years</span>
        </div>
        <div className={styles.infoRow}>
          <span className={styles.infoLabel}>Specialization:</span>
          <span className={styles.infoValue}>Laravel (4.3-12) + Vue.js</span>
        </div>
        <div className={styles.infoRow}>
          <span className={styles.infoLabel}>Current Role:</span>
          <span className={styles.infoValue}>Team Lead at Media Factory World</span>
        </div>
      </div>

      <div className={styles.philosophySection}>
        <h2>Leadership & Philosophy</h2>
        <p>
          Full Stack Engineer with 7+ years building and leading scalable systems in CRM, education, and logistics
          domains. Expert in Laravel (from 4.3 to 12), Vue.js, and API-driven architecture. Known for balancing clean
          code, strategic planning, and people-focused development.
        </p>
        <ul className={styles.principlesList}>
          <li>Advocate for logic-driven development over improvisation</li>
          <li>Committed to clean code, documentation, and SOLID architecture</li>
          <li>Believer in tech solutions aligned with real business needs</li>
          <li>Leads by example and promotes team ownership and collaboration</li>
        </ul>
      </div>
    </div>
  )
}

export default PersonalInfoFolder; // Export as default