"use client"
import React, { useState } from "react" // Import React
import { Folder, File, ChevronRight, HardDrive, Download, Users, ComputerIcon as Desktop, Search } from "lucide-react"
import styles from "./FileExplorer.module.css"

interface FileExplorerProps {
  openWindow: (app: any) => void;
}

const FileExplorer: React.FC<FileExplorerProps> = ({ openWindow }) => { // Add React.FC type and props
  const [currentPath, setCurrentPath] = useState("Documents")

  const handleItemClick = (itemType: string, itemName: string) => {
    if (itemType === "folder") {
      if (itemName === "Projects") {
        // Open the Projects window
        const projectsApp = {
          id: "projects",
          name: "Projects",
          icon: <Folder size={16} color="#00d4ff" />,
        }
        openWindow(projectsApp)
      } else {
        // Update the current path when clicking on a folder
        setCurrentPath(itemName)
      }
    } else if (itemType === "file" && itemName === "Resume.pdf") {
      // Open the resume PDF viewer
      const resumeApp = {
        id: "resume-pdf",
        name: "Resume.pdf",
        icon: <File size={16} color="#00d4ff" />,
      }
      openWindow(resumeApp)
    }
  }

  return (
    <div className={styles.fileExplorer}>
      <div className={styles.toolbar}>
        <div className={styles.toolbarButtons}>
          <button className={styles.toolbarButton}>File</button>
          <button className={styles.toolbarButton}>Home</button>
          <button className={styles.toolbarButton}>Share</button>
          <button className={styles.toolbarButton}>View</button>
        </div>
        <div className={styles.searchContainer}>
          <Search size={14} className={styles.searchIcon} />
          <input type="text" placeholder="Search" className={styles.searchInput} />
        </div>
      </div>

      <div className={styles.explorerContent}>
        <div className={styles.sidebar}>
          <div className={styles.sidebarSection}>
            <div className={styles.sidebarHeader}>Quick access</div>
            <div className={styles.sidebarItem} onClick={() => setCurrentPath("Desktop")}>
              <Desktop size={16} className={styles.sidebarIcon} />
              <span>Desktop</span>
            </div>
            <div className={styles.sidebarItem} onClick={() => setCurrentPath("Downloads")}>
              <Download size={16} className={styles.sidebarIcon} />
              <span>Downloads</span>
            </div>
            <div className={styles.sidebarItem} onClick={() => setCurrentPath("Documents")}>
              <Users size={16} className={styles.sidebarIcon} />
              <span>Documents</span>
            </div>
          </div>

          <div className={styles.sidebarSection}>
            <div className={styles.sidebarHeader}>This PC</div>
            <div className={styles.sidebarItem} onClick={() => setCurrentPath("Desktop")}>
              <Desktop size={16} className={styles.sidebarIcon} />
              <span>Desktop</span>
            </div>
            <div className={styles.sidebarItem} onClick={() => setCurrentPath("Documents")}>
              <Users size={16} className={styles.sidebarIcon} />
              <span>Documents</span>
            </div>
            <div className={styles.sidebarItem} onClick={() => setCurrentPath("Downloads")}>
              <Download size={16} className={styles.sidebarIcon} />
              <span>Downloads</span>
            </div>
            <div className={styles.sidebarItem} onClick={() => setCurrentPath("C:")}>
              <HardDrive size={16} className={styles.sidebarIcon} />
              <span>Local Disk (C:)</span>
            </div>
          </div>
        </div>

        <div className={styles.fileList}>
          <div className={styles.breadcrumb}>
            <span>This PC</span>
            <ChevronRight size={14} />
            <span>{currentPath}</span>
          </div>

          <div className={styles.files}>
            {currentPath === "Documents" && (
              <>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "Projects")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Projects</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "Resume")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Resume</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("file", "Resume.pdf")}>
                  <File size={40} className={styles.fileIcon} />
                  <span>Resume.pdf</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "Certificates")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Certificates</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "Personal")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Personal</span>
                </div>
              </>
            )}

            {currentPath === "Projects" && (
              <>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "PrepAI")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>PrepAI</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "PDF Splitter")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>PDF Splitter</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "Real Time Chat")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Real Time Chat</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "Rocket Health")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Rocket Health</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "E-Commerce API")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>E-Commerce API</span>
                </div>
              </>
            )}

            {currentPath === "Resume" && (
              <>
                <div className={styles.fileItem} onClick={() => handleItemClick("file", "Resume.pdf")}>
                  <File size={40} className={styles.fileIcon} />
                  <span>Resume.pdf</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("file", "Cover Letter.docx")}>
                  <File size={40} className={styles.fileIcon} />
                  <span>Cover Letter.docx</span>
                </div>
              </>
            )}

            {currentPath === "Certificates" && (
              <>
                <div className={styles.fileItem}>
                  <File size={40} className={styles.fileIcon} />
                  <span>Web Development.pdf</span>
                </div>
                <div className={styles.fileItem}>
                  <File size={40} className={styles.fileIcon} />
                  <span>React.pdf</span>
                </div>
                <div className={styles.fileItem}>
                  <File size={40} className={styles.fileIcon} />
                  <span>Node.js.pdf</span>
                </div>
              </>
            )}

            {currentPath === "Desktop" && (
              <>
                <div className={styles.fileItem} onClick={() => handleItemClick("folder", "Projects")}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Projects</span>
                </div>
                <div className={styles.fileItem} onClick={() => handleItemClick("file", "Resume.pdf")}>
                  <File size={40} className={styles.fileIcon} />
                  <span>Resume.pdf</span>
                </div>
              </>
            )}

            {currentPath === "Downloads" && (
              <>
                <div className={styles.fileItem} onClick={() => handleItemClick("file", "Resume.pdf")}>
                  <File size={40} className={styles.fileIcon} />
                  <span>Resume.pdf</span>
                </div>
                <div className={styles.fileItem}>
                  <File size={40} className={styles.fileIcon} />
                  <span>Project Documentation.pdf</span>
                </div>
              </>
            )}

            {currentPath === "C:" && (
              <>
                <div className={styles.fileItem}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Program Files</span>
                </div>
                <div className={styles.fileItem}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Users</span>
                </div>
                <div className={styles.fileItem}>
                  <Folder size={40} className={styles.folderIcon} />
                  <span>Windows</span>
                </div>
              </>
            )}
          </div>
        </div>
      </div>

      <div className={styles.statusBar}>
        <div className={styles.statusItem}>
          {currentPath === "Documents"
            ? "5 items"
            : currentPath === "Projects"
              ? "5 items"
              : currentPath === "Resume"
                ? "2 items"
                : currentPath === "Certificates"
                  ? "3 items"
                  : currentPath === "Desktop"
                    ? "2 items"
                    : currentPath === "Downloads"
                      ? "2 items"
                      : currentPath === "C:"
                        ? "3 items"
                        : "0 items"}
        </div>
      </div>
    </div>
  )
}

export default FileExplorer; // Export as default