# Cognitive OS – Terminal Console + Galaxy Preloader Prompt (for v0)

Act as a **senior Next.js 14 (App Router) frontend engineer + cinematic UI/motion director**.

You will generate production-ready **TypeScript React components** for a “Cognitive OS” landing page extension.

We need:

1. `/components/TerminalConsole.tsx` — upgraded, data-driven, CV-aware
2. `/components/PreloaderGalaxy.tsx` — dark-space / galaxy pre-loader
3. A short note on how to mount the preloader before the page renders
4. All code must be ready to drop into a Next.js 14 project (app router), using Tailwind.

---

## 1) TerminalConsole.tsx requirements

- `use client`
- dark terminal UI (`bg-black text-green-400 font-mono`)
- header: `cognitive-os@system:~$` + mute button
- scrollable output, auto-scroll to last line
- input with `>` prompt
- commands:

Base:
- `show insights`
- `help`
- `clear`

Cognitive:
- `expand consciousness` → fetch `/data/evolution.json`, cache, print current + next phase
- `trace evolution` → print ordered phases like `Awareness → Reflection → Collective → Neural Dialog` + `evolution path stable ✓` + `consciousness sync: 99.2%`

CV-aware (from appended CV):
- `show architect` → print name, role, focus
- `list skills` → print skills; if no CV → `> CV data not loaded.`

Must:
- all lines start with `>`
- respect `prefers-reduced-motion` / `prefers-reduced-audio`
- guard SSR (`typeof window !== "undefined"`)

---

## 2) PreloaderGalaxy.tsx

- full-screen `fixed inset-0 z-50`
- dark / space / galaxy gradients
- rotating orbs (if motion allowed)
- center text: “Booting Cognitive OS...” + “Awakening neural layers”
- call `onFinish()` after ~3s
- if reduced-motion → static

---

## 3) Integration (example)

```tsx
"use client";
import { useState } from "react";
import PreloaderGalaxy from "@/components/PreloaderGalaxy";
import HeroSection from "@/components/HeroSection";
import TerminalConsole from "@/components/TerminalConsole";

export default function Page() {
  const [loading, setLoading] = useState(true);
  return (
    <>
      {loading && <PreloaderGalaxy onFinish={() => setLoading(false)} />}
      {!loading && (
        <>
          <HeroSection />
          <TerminalConsole />
        </>
      )}
    </>
  );
}
```

---

## 4) Sample /public/data/evolution.json

```json
[
  { "id": 1, "name": "Awareness", "status": "Completed", "tests": 12, "order": 1, "summary": "System wakes to self-state." },
  { "id": 2, "name": "Reflection", "status": "Completed", "tests": 8, "order": 2, "summary": "Evaluating previous loops." },
  { "id": 3, "name": "Collective Intelligence", "status": "Ongoing", "tests": 5, "order": 3, "summary": "Sharing knowledge across modules." },
  { "id": 4, "name": "Neural Dialog", "status": "In Progress", "tests": 3, "order": 4, "summary": "Opening human–machine channel." }
]
```

---

## 5) Append CV below

[PASTE YOUR CV HERE]
