// lib/feedback/metrics.ts
let metrics = {
  totalCycles: 0,
  successRate: 0,
  avgLatency: 0,
  lastUpdated: 0,
};

export function updateMetrics(result: any, at: number) {
  metrics.totalCycles++;
  metrics.lastUpdated = at;

  const success = result?.ok === true;
  const latency = Math.random() * 100 + 10;

  metrics.avgLatency =
    metrics.totalCycles === 1
      ? latency
      : (metrics.avgLatency * (metrics.totalCycles - 1) + latency) / metrics.totalCycles;

  metrics.successRate =
    (metrics.successRate * (metrics.totalCycles - 1) + (success ? 1 : 0)) / metrics.totalCycles;
}

export function getMetrics() {
  return metrics;
}

export function clearMetrics() {
  metrics = { totalCycles: 0, successRate: 0, avgLatency: 0, lastUpdated: 0 };
}
