/**
 * @file meta_forecast.spec.ts
 * Unit tests لطبقة Meta-Forecast
 */

import { describe, it, expect } from 'vitest';
import { generateMetaForecast } from '@/lib/evolution/meta-forecast';
import * as timeline from '@/lib/evolution/timeline';
import * as predictive from '@/lib/evolution/predictive-engine';

describe('Meta Forecast Engine', () => {
  it('detects Integrate trend for rising stable data', () => {
    vi.spyOn(timeline, 'getTimelineHistory').mockReturnValue(
      Array.from({ length: 10 }, (_, i) => ({
        stability: 0.6 + i * 0.03,
        timestamp: new Date().toISOString(),
      }))
    );
    vi.spyOn(predictive, 'getPredictiveConfidence').mockReturnValue(0.9);

    const result = generateMetaForecast();
    expect(result.trend).toBe('Integrate');
  });

  it('detects Reset trend for declining data', () => {
    vi.spyOn(timeline, 'getTimelineHistory').mockReturnValue(
      Array.from({ length: 10 }, (_, i) => ({
        stability: 0.9 - i * 0.05,
        timestamp: new Date().toISOString(),
      }))
    );
    vi.spyOn(predictive, 'getPredictiveConfidence').mockReturnValue(0.8);

    const result = generateMetaForecast();
    expect(result.trend).toBe('Reset');
  });

  it('outputs consistent timestamp', () => {
    vi.spyOn(timeline, 'getTimelineHistory').mockReturnValue([
      { stability: 0.7, timestamp: new Date().toISOString() },
    ]);
    vi.spyOn(predictive, 'getPredictiveConfidence').mockReturnValue(0.8);

    const result = generateMetaForecast();
    expect(result.timestamp).toMatch(/\d{4}-\d{2}-\d{2}T/);
  });
});
