import { describe, it, expect } from 'vitest';
import { PolicyManager } from '../../lib/policies/PolicyManager';
import fs from 'node:fs';
import { appendPolicyTelemetry } from '../../lib/integration/policy_telemetry';

describe('🧩 Phase 8.5 — Responsive Policy Integration', () => {
  it('detects environment snapshot correctly', () => {
    const snap = PolicyManager.detect();
    expect(['mobile', 'desktop']).toContain(snap.device);
    expect(['low', 'medium', 'high']).toContain(snap.performance);
  });

  it('logs policy snapshot into Evolution_Report.json', () => {
    const snap = PolicyManager.detect();
    appendPolicyTelemetry(snap);
    const data = JSON.parse(fs.readFileSync('./storage/Evolution_Report.json', 'utf8'));
    expect(data.responsivePolicy.device).toBeDefined();
    expect(data.lastPolicyUpdate).toBeDefined();
  });
});
