import React from 'react';
import { customRender, screen, fireEvent } from '@/tests/utils/test-render';
import Desktop from '@/components/Desktop';
import { desktopApps } from '@/data/apps';
import { awarenessEmit } from '@/tests/utils/awareness';
import { telemetry } from '@/tests/utils/telemetry';
import { captureSnapshotWithMeta } from '@/tests/utils/snapshot';

describe('Window Manager Integration', () => {
  it('renders the desktop and responds to window open', () => {
    const t = telemetry.time('Desktop render');
    const props = {
      openWindow: vi.fn((app: any) => awarenessEmit({ type: 'WINDOW_OPENED', windowId: app.id })),
      openWindows: [],
      closeWindow: vi.fn(),
      minimizeWindow: vi.fn(),
      minimizedWindows: [],
      activeWindow: null,
      setActiveWindow: vi.fn(),
      windowStates: {},
      setWindowState: vi.fn(),
    };

    const { container } = customRender(<Desktop {...props} />);
    t.end();

    // Desktop موجود
    expect(container.querySelector('.desktop')).toBeTruthy();

    // Double-click على أول أيقونة
    const first = desktopApps[0];
    const icon = screen.getByText(first.name);
    fireEvent.doubleClick(icon);

    // سنابشوت enriched
    const snap = captureSnapshotWithMeta(container, {
      expectOpen: first.id,
      openCount: props.openWindows?.length ?? 0,
    });
    expect(snap).toMatchSnapshot();
  });
});
