// ============================================================
// 🧠 Jemy-dev OS — Vitest Global Setup (Phase 9.3)
// Unified environment for HUD, NeuralVoice, Depth, and AI Summary tests
// ============================================================

import '@testing-library/jest-dom';
import { beforeAll, afterEach, vi } from 'vitest';
import { cleanup } from '@testing-library/react';
import { initializeHUDMockEnvironment } from '@/tests/setup/hud.mock-env';

// 🧩 تنظيف DOM بعد كل اختبار
afterEach(() => {
  cleanup();
  vi.useRealTimers();
  vi.restoreAllMocks();
});

// ============================================================
// 🧩 البيئة الأساسية قبل التشغيل
// ============================================================

beforeAll(() => {
  if (typeof window === 'undefined') return;

  // ----------------------------------------------------------
  // 🧠 تهيئة البيئة الكاملة للـ HUD (Speech / DOM / Storage)
  // ----------------------------------------------------------
  initializeHUDMockEnvironment();

  // ----------------------------------------------------------
  // 🎨 Mock لـ matchMedia (Helps motion/media-query components)
  // ----------------------------------------------------------
  Object.defineProperty(window, 'matchMedia', {
    writable: true,
    value: (query: string) => ({
      matches: false,
      media: query,
      onchange: null,
      addListener: vi.fn(), // legacy
      removeListener: vi.fn(),
      addEventListener: vi.fn(),
      removeEventListener: vi.fn(),
      dispatchEvent: vi.fn(),
    }),
  });

  // ----------------------------------------------------------
  // 🔒 Math.random ثابت + وقت ثابت للـ Snapshots
  // ----------------------------------------------------------
  vi.spyOn(Math, 'random').mockReturnValue(0.42);
  vi.setSystemTime(new Date('2025-01-01T00:00:00Z'));

  // ----------------------------------------------------------
  // 🧩 Flag بيأكد تشغيل الـ Mock HUD Reporter لو حبيت تشغله
  // ----------------------------------------------------------
  localStorage.setItem('HUD_MOCK_ACTIVE', 'true');
});
