import path from 'path';
import { defineConfig } from 'vitest/config';
import react from '@vitejs/plugin-react-swc';

export default defineConfig({
  plugins: [react()],
  resolve: {
    alias: {
      '@': path.resolve(__dirname, './'),
      '@/tests': path.resolve(__dirname, './tests'),
    },
  },
  test: {
    globals: true,
    environment: 'jsdom',
    setupFiles: './vitest.setup.ts',
    include: [
      'components/**/*.test.{ts,tsx}',
      'tests/**/*.spec.{ts,tsx}',
      'components/__tests__/**/*.test.{ts,tsx}',
    ],
    includeSource: [
      'components/**/*.{ts,tsx}',
      'app/**/*.{ts,tsx}',
      'data/**/*.{ts,tsx}',
      'lib/**/*.{ts,tsx}',
      'lib/reflection/**/*.{ts,tsx}',
    ],
    // ✅ سنابشوتات بميتا (هتستخدم الهيلبر تحت)
    snapshotFormat: { printBasicPrototype: false },
    // ✅ غلق التايمرز العشوائية في التيست
    fakeTimers: { toFake: ['setTimeout', 'setInterval', 'Date'] },
    // ✅ تغطية أولية مع استثناء مكونات ثقيلة/ثالثة
    coverage: {
      provider: 'v8',
      thresholds: undefined,
      reporter: ['text', 'html', 'lcov'],
      // reportsDirectory: './coverage',
      reportsDirectory: './tests/coverage',
      all: true,
      include: [
        'components/**/*.{ts,tsx}',
        'app/**/*.{ts,tsx}',
        'data/**/*.{ts,tsx}',
        'lib/**/*.{ts,tsx}',
        'lib/reflection/**/*.{ts,tsx}',
      ],
      exclude: [
        'components/ui/**',
        'components/**/WindowContent.module.css',
        'components/Loader.tsx',
        'components/ReducedMotionProvider.tsx',
        'app/layout.tsx',
        '**/*.d.ts',
        '**/*.config.*',
        'node_modules/**',
        'lib/**/index.ts',
        'lib/**/types.ts',
        'components/**/*.stories.tsx',
        'node_modules/**',
      ],
      // thresholds: {
      //   statements: 40,
      //   branches: 30,
      //   functions: 35,
      //   lines: 40,
      // },
    },
  },
  esbuild: {
    // حقن React تلقائيًا لو لزم
    jsxInject: `import React from 'react'`,
  },
});
