import { prettyDOM } from '@testing-library/dom';

export function captureSnapshotWithMeta(container: HTMLElement, meta: Record<string, any>) {
  const dom = prettyDOM(container, 10000) || '';
  return {
    meta: {
      ...meta,
      timestamp: new Date().toISOString(),
    },
    dom,
  };
}
