// tests/phase9/hud/neural-voice-hud.spec.tsx
import { describe, it, expect, vi, beforeEach, afterEach } from "vitest";
import { render, screen, act, cleanup } from "@testing-library/react";
import { NeuralVoiceHUD } from "@/lib/awareness/collective/components/NeuralVoiceHUD";

/**
 * Neural Voice HUD Tests (Phase 9.3)
 * Validates rendering, speech initiation, and close behavior.
 */

describe("NeuralVoiceHUD", () => {
  beforeEach(() => {
    // ✅ Mock voice synthesis to avoid browser dependency
    vi.stubGlobal("speechSynthesis", {
      speak: vi.fn(),
      cancel: vi.fn(),
      getVoices: () => [
        { name: "MockVoice", lang: "en-US", default: true },
      ],
    });
  });

  afterEach(() => {
    cleanup();
    vi.unstubAllGlobals();
  });

  it("renders header title", () => {
    render(<NeuralVoiceHUD onClose={() => {}} />);
    expect(screen.getByText("Neural Voice HUD")).toBeInTheDocument();
  });

  it("starts voice synthesis automatically", async () => {
    vi.mock(
      "@/lib/awareness/collective/analysis/neural-summary-generator",
      () => ({
        generateNeuralSummary: () => "Mock voice summary",
      })
    );

    render(<NeuralVoiceHUD onClose={() => {}} />);
    await act(async () => {
      await new Promise((r) => setTimeout(r, 500));
    });

    // ✅ Accept both “Speaking summary” or “Paused” mock states
    const texts = screen.queryAllByText(/(Mock voice summary|Paused)/i);
expect(texts.length).toBeGreaterThan(0);
  });

  it("triggers onClose correctly", async () => {
    const onClose = vi.fn();
    render(<NeuralVoiceHUD onClose={onClose} />);
    const btn = screen.getByText("Close");
    await act(async () => btn.click());
    expect(onClose).toHaveBeenCalledOnce();
  });
});
