// tests/phase9/hud/depth-provider.spec.ts
import { describe, it, expect, beforeEach, afterEach, vi } from 'vitest';
import { renderHook, act } from '@testing-library/react';
import {
  DepthProvider,
  useDepthField,
} from '@/lib/awareness/collective/components/hud/hud.depth-sync';

/**
 * Depth Provider Tests (Phase 9.3)
 * Ensures parallax depth reacts correctly to cursor movement
 * and resets on cleanup.
 */

describe('DepthProvider', () => {
  beforeEach(() => {
    // ✅ useRealTimers to avoid collision with global setSystemTime
    vi.useRealTimers();
  });

  afterEach(() => {
    vi.restoreAllMocks();
  });

  it('initializes with zero depth', () => {
    const { result } = renderHook(() => useDepthField(), {
      wrapper: DepthProvider,
    });
    expect(result.current.x).toBe(0);
    expect(result.current.y).toBe(0);
  });

  it('updates on mousemove with correct intensity', () => {
    const { result } = renderHook(() => useDepthField(), {
      wrapper: DepthProvider,
    });

    act(() => {
      window.dispatchEvent(new MouseEvent('mousemove', { clientX: 400, clientY: 300 }));
    });

    expect(result.current).toHaveProperty('intensity');
    expect(result.current.intensity).toBeGreaterThanOrEqual(0);
  });

  it('resets smoothly on unmount', () => {
    const { unmount, result } = renderHook(() => useDepthField(), {
      wrapper: DepthProvider,
    });

    act(() => {
      window.dispatchEvent(new MouseEvent('mousemove', { clientX: 800, clientY: 400 }));
    });

    const beforeUnmount = { ...result.current };
    unmount();

    expect(beforeUnmount).not.toBeNull();
  });
});
