import { describe, it, expect, beforeAll } from 'vitest';
import fs from 'node:fs';
import path from 'node:path';
import { showCollectiveDashboard } from '../../lib/dashboard/collective_dashboard';

const TMP_REPORT = './storage/tests/phase8/Integration_Report.json';

describe('🧩 Phase 8 — Collective Dashboard CLI', () => {
  beforeAll(() => {
    fs.mkdirSync(path.dirname(TMP_REPORT), { recursive: true });
    fs.writeFileSync(
      TMP_REPORT,
      JSON.stringify({
        timestamp: new Date().toISOString(),
        nodes: [
          { nodeId: 'node-A', trust: 0.8 },
          { nodeId: 'node-B', trust: 0.75 },
        ],
        metrics: {
          collectiveStability: 0.76,
          collaborationIndex: 0.28,
          metaResonance: 0.6,
          nextEvolutionDirective: 'Expand',
        },
        notes: {
          interpretation: 'المجتمع مستقر وجاهز للتوسع.',
          guidance: 'نفّذ تغييرات صغيرة وراقب metaResonance.',
        },
      })
    );
  });

  it('should print dashboard without errors', () => {
    expect(() => showCollectiveDashboard(TMP_REPORT)).not.toThrow();
  });
});
