export const clamp = (v: number, min: number, max: number) => Math.max(min, Math.min(max, v));

export const mean = (arr: number[]) =>
  arr.length ? arr.reduce((a, b) => a + b, 0) / arr.length : 0;

export const variance = (arr: number[]) => {
  if (!arr.length) return 0;
  const m = mean(arr);
  return mean(arr.map((x) => (x - m) ** 2));
};

export const momentum = (delta: number, prevDelta: number) => 0.7 * delta + 0.3 * prevDelta; // smoothing

export const sign = (x: number) => (x > 0 ? 1 : x < 0 ? -1 : 0);
