export type PolicyStatus = 'active' | 'frozen' | 'review';

export interface PolicyMeta {
  policyId: string;
  name: string;
  description: string;
  weight: number;
  status: PolicyStatus;
  trend: '↑' | '↓' | '→';
  lastUpdate: string;
  _lastDelta?: number;
}

export interface PolicyHistoryRecord {
  policyId: string;
  oldWeight: number;
  newWeight: number;
  trend: '↑' | '↓' | '→';
  timestamp: string;
  reason: string;
  correlation: -1 | 0 | 1;
}
