export type IntentKind =
  | 'PIN'
  | 'EXPORT_CSV'
  | 'EXPORT_JSON'
  | 'EXPORT_PDF'
  | 'EXPORT_LOGS_CSV'
  | 'EXPORT_LOGS_JSON'
  | 'OPEN_SUMMARY'
  | 'CLOSE_SUMMARY'
  | 'AUTO_START'
  | 'AUTO_STOP'
  | 'HELP';

export type ParsedIntent = { kind: IntentKind; reply?: string } | null;

export function parseIntent(text: string): ParsedIntent {
  const q = (text || '').toLowerCase();
  if (/pin( this)?/.test(q)) return { kind: 'PIN', reply: 'Insight pinned.' };
  if (/export logs csv/.test(q)) return { kind: 'EXPORT_LOGS_CSV' };
  if (/export logs json/.test(q)) return { kind: 'EXPORT_LOGS_JSON' };
  if (/export csv/.test(q)) return { kind: 'EXPORT_CSV' };
  if (/export json/.test(q)) return { kind: 'EXPORT_JSON' };
  if (/export pdf/.test(q)) return { kind: 'EXPORT_PDF' };
  if (/open (ai )?summary/.test(q)) return { kind: 'OPEN_SUMMARY' };
  if (/close (ai )?summary/.test(q)) return { kind: 'CLOSE_SUMMARY' };
  if (/start auto( |-)?snapshot/.test(q)) return { kind: 'AUTO_START' };
  if (/stop auto( |-)?snapshot/.test(q)) return { kind: 'AUTO_STOP' };
  if (/help|what can you do|commands/.test(q))
    return {
      kind: 'HELP',
      reply:
        'Say: pin this, export csv/json/pdf, export logs csv/json, open/close summary, start/stop autosnapshot.',
    };
  return null;
}
