/**
 * Mutation Utilities
 * أدوات لتوليد نسخ معدلة من السياسات (mutations)
 */

/**
 * يولّد وزن جديد بناءً على معدل الطفرة المحدد.
 */
export function mutateWeight(baseWeight: number, rate: number): number {
  const delta = (Math.random() * 2 - 1) * rate; // -rate ↔ +rate
  const mutated = baseWeight + delta;
  // نحافظ على القيم بين 0.05 و 1.0
  return Math.min(1, Math.max(0.05, mutated));
}
