// lib/evolution/calibration.utils.ts
export function mean(xs: number[]) {
  if (!xs.length) return 0;
  return xs.reduce((a, b) => a + b, 0) / xs.length;
}

export function stdev(xs: number[]) {
  if (xs.length < 2) return 0;
  const m = mean(xs);
  const v = mean(xs.map((x) => (x - m) ** 2));
  return Math.sqrt(v);
}

export function minmax(xs: number[]) {
  if (!xs.length) return { min: 0, max: 0 };
  return { min: Math.min(...xs), max: Math.max(...xs) };
}

export function clamp(x: number, [lo, hi]: [number, number]) {
  return Math.max(lo, Math.min(hi, x));
}

export function movingAverage(xs: number[], k: number) {
  if (!xs.length || k <= 1) return xs.slice();
  const out: number[] = [];
  for (let i = 0; i < xs.length; i++) {
    const start = Math.max(0, i - k + 1);
    const slice = xs.slice(start, i + 1);
    out.push(mean(slice));
  }
  return out;
}
