  import React from 'react';
import { buildTimeline } from '@/lib/evolution/timeline';
import { predictNext } from '@/lib/evolution/predictive-engine';
import { useResponsivePolicy } from '../hooks/useResponsivePolicy';

export const TimelineDashboard: React.FC = () => {
  const timeline = buildTimeline();
  const prediction = predictNext(timeline);
  const { policy } = useResponsivePolicy();

  if (!timeline.length)
    return <p>No evolution history yet.</p>;

  return (
    <div className="timeline-dashboard p-4 border rounded-md">
      <h3 className="font-bold mb-2">📅 Evolution Timeline</h3>
      <ul className="text-sm mb-3">
        {timeline.map((e, i) => (
          <li key={i}>
            <span>{e.t}</span> → Stability {(e.stability * 100).toFixed(1)}% ({e.directive})
          </li>
        ))}
      </ul>

      {prediction && (
        <div className="prediction p-3 bg-gray-900/70 text-white rounded-lg">
          <h4 className="font-semibold mb-1">🔮 Next Forecast</h4>
          <p>
            Directive: <strong>{prediction.nextDirective}</strong><br />
            Expected Stability: {(prediction.predictedStability * 100).toFixed(1)}%<br />
            Confidence: {Math.round(prediction.confidence * 100)}%
          </p>
          <p className="text-xs mt-2 opacity-80">
            Device Context: {policy.device} | Perf Mode: {policy.behavior.perfMode ? 'On' : 'Off'}
          </p>
        </div>
      )}
    </div>
  );
};
