import React from 'react';
import { useResponsivePolicy } from '../hooks/useResponsivePolicy';

export const PolicyGuard: React.FC<React.PropsWithChildren<{ className?: string }>> = ({ children, className }) => {
  const { policy } = useResponsivePolicy();

  const densityClass =
    policy.ui.density === 'compact'
      ? 'density-compact'
      : policy.ui.density === 'expanded'
      ? 'density-expanded'
      : 'density-default';

  const layoutClass =
    policy.ui.layout === 'single-column'
      ? 'layout-single'
      : policy.ui.layout === 'two-column'
      ? 'layout-two'
      : 'layout-grid';

  const perfClass = policy.behavior.perfMode ? 'perf-on' : 'perf-off';

  return (
    <div className={`${densityClass} ${layoutClass} ${perfClass} ${className || ''}`.trim()}>
      {children}
    </div>
  );
};
