/**
 * @file ParallaxGlow.tsx
 * Animated radial glows that follow the cursor with gentle parallax
 */

import React, { useEffect, useRef } from "react";

export const ParallaxGlow: React.FC = () => {
  const refA = useRef<HTMLDivElement>(null);
  const refB = useRef<HTMLDivElement>(null);

  useEffect(() => {
    const move = (e: MouseEvent) => {
      const { innerWidth, innerHeight } = window;
      const x = (e.clientX / innerWidth - 0.5) * 2;  // -1..1
      const y = (e.clientY / innerHeight - 0.5) * 2; // -1..1

      if (refA.current) {
        refA.current.style.transform = `translate(${x * 12}px, ${y * 8}px)`;
      }
      if (refB.current) {
        refB.current.style.transform = `translate(${x * -10}px, ${y * -6}px)`;
      }
    };
    window.addEventListener("mousemove", move);
    return () => window.removeEventListener("mousemove", move);
  }, []);

  return (
    <div className="pointer-events-none absolute inset-0 -z-10">
      <div
        ref={refA}
        className="parallax-glow"
        style={{
          width: 520,
          height: 520,
          top: -140,
          left: -120,
          background:
            "radial-gradient(closest-side, rgba(244,123,70,0.24), rgba(244,123,70,0) 65%)",
          filter: "blur(60px)",
        }}
      />
      <div
        ref={refB}
        className="parallax-glow"
        style={{
          width: 440,
          height: 440,
          bottom: -90,
          right: -70,
          background:
            "radial-gradient(closest-side, rgba(12,122,122,0.18), rgba(12,122,122,0) 65%)",
          filter: "blur(60px)",
        }}
      />
    </div>
  );
};
