/**
 * @file AdaptiveTimeline.tsx
 * Line Chart ديناميكي يعرض استقرار النظام عبر الزمن
 */

import React from "react";
import {
  LineChart,
  Line,
  XAxis,
  YAxis,
  Tooltip,
  ResponsiveContainer,
  CartesianGrid,
} from "recharts";
import { getTimelineHistory } from "@/lib/evolution/timeline";

export const AdaptiveTimeline: React.FC = () => {
  const data = getTimelineHistory().map((entry) => ({
    time: new Date(entry.timestamp).toLocaleTimeString(),
    stability: entry.stability,
  }));

  const getColor = (value: number) => {
    if (value > 0.75) return "#00ff88"; // أخضر - مستقر
    if (value > 0.5) return "#f4d03f"; // أصفر - متوسط
    return "#ff4d4f"; // أحمر - اضطراب
  };

  return (
    <div className="adaptive-timeline w-full h-64 bg-[#0c0c0c] rounded-2xl p-4 shadow-lg">
      <h3 className="text-[#f47b46] mb-3 font-semibold text-lg">
        System Stability Over Time
      </h3>
      <ResponsiveContainer width="100%" height="100%">
        <LineChart data={data}>
          <CartesianGrid strokeDasharray="3 3" stroke="#333" />
          <XAxis dataKey="time" stroke="#888" />
          <YAxis domain={[0, 1]} stroke="#888" />
          <Tooltip
            contentStyle={{
              backgroundColor: "#1a1a1a",
              border: "1px solid #f47b46",
              borderRadius: "10px",
            }}
          />
          <Line
            type="monotone"
            dataKey="stability"
            stroke="#00ff88"
            strokeWidth={2}
            dot={({ payload }) => (
              <circle
                cx={payload.cx}
                cy={payload.cy}
                r={4}
                fill={getColor(payload.stability)}
              />
            )}
          />
        </LineChart>
      </ResponsiveContainer>
    </div>
  );
};
