import { getPinnedInsights } from '@/lib/evolution/history.pins';

export function generateAISummary() {
  const pins = getPinnedInsights();
  if (!pins.length) return 'No pinned insights available for analysis.';

  const total = pins.length;
  const reformCount = pins.filter((p) => p.trend === 'Reform').length;
  const integrateCount = pins.filter((p) => p.trend === 'Integrate').length;
  const resetCount = pins.filter((p) => p.trend === 'Reset').length;

  const avgConfidence = pins.reduce((sum, p) => sum + (p.confidence || 0), 0) / total;

  const dominantTrend =
    reformCount >= integrateCount && reformCount >= resetCount
      ? 'Reform'
      : integrateCount >= resetCount
      ? 'Integrate'
      : 'Reset';

  let summary = `🧠 **AI Predictive Summary**
Total Insights: ${total}
Average Confidence: ${(avgConfidence * 100).toFixed(1)}%
Dominant Trend: ${dominantTrend}`;

  if (dominantTrend === 'Reform')
    summary += `\n→ The system exhibits adaptive restructuring patterns. Stability maintained with moderate confidence.`;
  if (dominantTrend === 'Integrate')
    summary += `\n→ Integration signals are increasing — potential system unification detected.`;
  if (dominantTrend === 'Reset')
    summary += `\n→ System reset phase indicators present. Evaluate consistency and recovery cycle.`;

  return summary;
}
