import React from 'react';
import { PolicyProvider } from './context/PolicyContext';
import { PolicyGuard } from './components/PolicyGuard';
import { IntegrationBridge } from './IntegrationBridge';

import { TimelineDashboard } from './components/TimelineDashboard';

const AwarenessSummary = () => (
  <section aria-label="Awareness Summary">
    <header className="widget-title">Collective Awareness</header>
    <p>Charts and metrics render according to current responsive policy.</p>
  </section>
);
<PolicyGuard className="collective-dashboard p-4">

  <AwarenessSummary />
  <TimelineDashboard />
</PolicyGuard>

export default function CollectiveDashboard() {
  return (
    <PolicyProvider>
      <IntegrationBridge />
      <PolicyGuard className="collective-dashboard">
        <AwarenessSummary />
      </PolicyGuard>
    </PolicyProvider>
  );
}
