import { render, screen } from '@testing-library/react';
import { describe, it, expect, vi } from 'vitest';
import TopBar from './TopBar';

describe('TopBar', () => {
  it('renders correctly with activities button and title', () => {
    const toggleActivitiesMock = vi.fn();
    const onLogoutMock = vi.fn();

    render(
      <TopBar
        toggleActivities={toggleActivitiesMock}
        activitiesOpen={false}
        onLogout={onLogoutMock}
      />
    );

    // Check if the "Activities" button is rendered
    expect(screen.getByRole('button', { name: /activities/i })).toBeInTheDocument();

    // Check if the title is rendered
    expect(screen.getByText(/Mohamed Gamal - Portfolio/i)).toBeInTheDocument();

    // Check if the power button is rendered
    expect(screen.getByRole('button', { name: /power/i })).toBeInTheDocument();
  });
});
