"use client"
import React from "react" // Import React
import { ExternalLink } from "lucide-react"
import styles from "./FolderContent.module.css"

const ProjectsFolder: React.FC = () => { // Add React.FC type
  return (
    <div className={styles.folderContainer}>
      <h1 className={styles.folderTitle}>Projects Portfolio</h1>

      <div className={styles.projectItem}>
        <h2>Easy Cook</h2>
        <div className={styles.projectMeta}>
          <span className={styles.role}>Role: Lead Backend Engineer</span>
          <span className={styles.stack}>Stack: Laravel, FullCalendar.js, Notifications</span>
        </div>
        <p className={styles.projectDescription}>
          Architected and implemented a subscription-based nutrition platform with role-specific dashboards (Admin,
          Nutritionist, User). Developed logic to track and display meals, macros, and progress using FullCalendar.
          Integrated real-time feedback and payment flow.
        </p>
        <div className={styles.projectHighlight}>💡 Processed over 1,000 assessments/month</div>
      </div>

      <div className={styles.projectItem}>
        <h2>Yousry Group Unified Platform</h2>
        <div className={styles.projectMeta}>
          <span className={styles.role}>Role: Team Lead</span>
          <span className={styles.stack}>Stack: Laravel, Vue.js, Modular Monolith</span>
        </div>
        <p className={styles.projectDescription}>
          Led the engineering of a multi-module internal system (orders, vacation, notifications, chat, emails,
          transport tracking). Directed a team of 3+ developers, reviewed PRs, and implemented a queue-based
          notification engine with role-based workflows.
        </p>
      </div>

      <div className={styles.projectItem}>
        <h2>Education Matching System</h2>
        <div className={styles.projectMeta}>
          <span className={styles.role}>Role: System Designer</span>
          <span className={styles.stack}>Stack: Laravel, Matching Engine, Scheduling</span>
        </div>
        <p className={styles.projectDescription}>
          Designed and built a smart engine that matches student requests (subject, gender preference, grade level) with
          nearest available teachers. The system auto-generates a proposed lesson schedule and syncs with the calendar
          module.
        </p>
      </div>

      <div className={styles.projectItem}>
        <h2>OrderFei (Shopify)</h2>
        <div className={styles.projectMeta}>
          <span className={styles.role}>Role: Shopify Developer</span>
          <span className={styles.stack}>Stack: Shopify, WhatsApp Checkout, MyFatoorah</span>
        </div>
        <p className={styles.projectDescription}>
          Developed a bilingual beauty & medical store using Shopify. Customized the theme, optimized mobile checkout
          flow, and built a WhatsApp order redirection system to bypass online payment complexity while integrating
          local gateways (MyFatoorah).
        </p>
      </div>

      <div className={styles.projectItem}>
        <h2>Botit Application</h2>
        <div className={styles.projectMeta}>
          <span className={styles.role}>Role: Senior Backend Developer</span>
          <span className={styles.stack}>Stack: Laravel, MongoDB, Mobile API Sync</span>
        </div>
        <div className={styles.projectLinks}>
          <a href="https://www.botitapp.com/" target="_blank" rel="noopener noreferrer" className={styles.projectLink}>
            <ExternalLink size={14} /> Visit Website
          </a>
        </div>
        <p className={styles.projectDescription}>
          Contributed 45% to backend development of a smart food delivery and automation platform. Built scalable data
          models, user segmentation, and integrated with mobile APIs for real-time menu, location, and cart sync. Worked
          directly with lead product managers for fast iterations.
        </p>
      </div>
    </div>
  )
}

export default ProjectsFolder; // Export as default