// tests/feedback/memory.spec.ts
import { describe, it, expect } from 'vitest';
import { recordFeedback, getTimeline, getLastActions } from '../../lib/feedback/memory';
import type { FeedbackEvent } from '../../lib/feedback/types';

describe('Memory Timeline Tests', () => {
  it('should record new feedback events', async () => {
    const event: FeedbackEvent = {
      at: Date.now(),
      evaluation: {
        score: 40,
        severity: 'WARNING',
        confidence: 0.6,
        reasons: [],
        bucket: 'VOLATILE',
      },
      chosenAction: { id: 'x1', kind: 'ADJUST_RATE' },
      policyVersion: '1.0.0',
      result: { actionId: 'x1', latencyMs: 120, ok: true }, // تأكيد وجود نتيجة لتفادي undefined
    };
    await recordFeedback(event);
    expect(getTimeline().length).toBeGreaterThan(0);
  });

  it('should retrieve last actions correctly', async () => {
    const last = getLastActions('ADJUST_RATE');
    expect(Array.isArray(last)).toBe(true);
  });
});
