/**
 * CLI runner for Phase 6.2
 * Usage: pnpm tsx lib/runners/policy_tracker_runner.ts
 */
import { updateAllPolicies } from '../policy/tracker_engine';
import { loadRegistry } from '../policy/registry';

(async () => {
  console.log('🚀 Running Policy Tracker...');
  const res = updateAllPolicies();
  console.log('evolutionScore:', res.evolutionScore.toFixed(4));
  console.log('updated policies:', res.updatedCount);
  console.log('—— Registry snapshot ——');
  console.log(JSON.stringify(loadRegistry(), null, 2));
  console.log('✅ Done.');
})();
