// lib/reflection/flags.ts

const isTest = process.env.NODE_ENV === 'test';
const isProd = process.env.NODE_ENV === 'production';

/**
 * Checks if the entire self-reflection layer is enabled.
 */
export function isReflectionEnabled(): boolean {
  // If an explicit REFLECTION_ENABLED env var is provided, trust it across envs
  if (typeof process.env.REFLECTION_ENABLED !== 'undefined') {
    return process.env.REFLECTION_ENABLED === 'true';
  }

  if (isTest) {
    return process.env.TEST_REFLECTION === 'true';
  }

  if (isProd) {
    return false; // default off in production unless explicitly enabled
  }

  return true; // Default to true in development
}

/**
 * Checks if the reflection system is in DRY_RUN mode.
 */
export function isDryRun(): boolean {
  // In test, default to false unless specified, to allow policy application to be tested.
  if (isTest) {
    return process.env.REFLECTION_DRY_RUN === 'true';
  }
  // In prod/dev, default to true for safety.
  return process.env.REFLECTION_DRY_RUN !== 'false';
}

/**
 * Checks if verbose logging for the reflection layer is enabled.
 */
export function isVerbose(): boolean {
  if (!isReflectionEnabled()) return false;
  return (
    process.env.REFLECTION_VERBOSE === 'true' ||
    process.env.TEST_REFLECTION_VERBOSE === 'true' ||
    false
  );
}
