// lib/core/policies/types.ts
export type DeviceKind = 'mobile' | 'tablet' | 'desktop';
export type Density = 'compact' | 'default' | 'expanded';

export interface Policy {
  device: DeviceKind;
  ui: {
    density: Density;
    charts: 'summary' | 'full';
    animations: 'off' | 'reduced' | 'full';
    layout: 'single-column' | 'two-column' | 'grid';
    notifications: 'toast' | 'modal';
  };
  behavior: {
    perfMode: boolean;
    haptics: boolean;
    preloadData: boolean;
    timelineSpanDays: number;
  };
  data: {
    aggregateLevel: 'daily' | 'weekly' | 'monthly';
    maxItemsPerWidget: number;
  };
  /** قياس ثقة الاستنتاج (للتقارير والتنبؤ لاحقًا) */
  meta?: {
    confidence: number; // 0 → تخمين / 1 → دقيق
  };
}

export interface PolicyContextState {
  policy: Policy;
  device: DeviceKind;
  setOverrides: (o: Partial<Policy>) => void;
  clearOverrides: () => void;
}
